/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BatonSecretKey;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST3SecretKey;
import iaik.pkcs.pkcs11.objects.CAST5SecretKey;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.CDMFSecretKey;
import iaik.pkcs.pkcs11.objects.DES2SecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.IDEASecretKey;
import iaik.pkcs.pkcs11.objects.JuniperSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.SkipJackSecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class SecretKey
extends Key {
    protected BooleanAttribute sensitive_;
    protected BooleanAttribute encrypt_;
    protected BooleanAttribute decrypt_;
    protected BooleanAttribute sign_;
    protected BooleanAttribute verify_;
    protected BooleanAttribute wrap_;
    protected BooleanAttribute unwrap_;
    protected BooleanAttribute extractable_;
    protected BooleanAttribute alwaysSensitive_;
    protected BooleanAttribute neverExtractable_;

    public SecretKey() {
        this.objectClass_.setLongValue(Object.ObjectClass.SECRET_KEY);
    }

    protected SecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.objectClass_.setLongValue(Object.ObjectClass.SECRET_KEY);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.sensitive_ = new BooleanAttribute(Attribute.SENSITIVE);
        this.encrypt_ = new BooleanAttribute(Attribute.ENCRYPT);
        this.decrypt_ = new BooleanAttribute(Attribute.DECRYPT);
        this.sign_ = new BooleanAttribute(Attribute.SIGN);
        this.verify_ = new BooleanAttribute(Attribute.VERIFY);
        this.wrap_ = new BooleanAttribute(Attribute.WRAP);
        this.unwrap_ = new BooleanAttribute(Attribute.UNWRAP);
        this.extractable_ = new BooleanAttribute(Attribute.EXTRACTABLE);
        this.alwaysSensitive_ = new BooleanAttribute(Attribute.ALWAYS_SENSITIVE);
        this.neverExtractable_ = new BooleanAttribute(Attribute.NEVER_EXTRACTABLE);
        SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        SecretKey secretKey = (SecretKey)super.clone();
        secretKey.sensitive_ = (BooleanAttribute)this.sensitive_.clone();
        secretKey.encrypt_ = (BooleanAttribute)this.encrypt_.clone();
        secretKey.decrypt_ = (BooleanAttribute)this.decrypt_.clone();
        secretKey.sign_ = (BooleanAttribute)this.sign_.clone();
        secretKey.verify_ = (BooleanAttribute)this.verify_.clone();
        secretKey.wrap_ = (BooleanAttribute)this.wrap_.clone();
        secretKey.unwrap_ = (BooleanAttribute)this.unwrap_.clone();
        secretKey.extractable_ = (BooleanAttribute)this.extractable_.clone();
        secretKey.alwaysSensitive_ = (BooleanAttribute)this.alwaysSensitive_.clone();
        secretKey.neverExtractable_ = (BooleanAttribute)this.neverExtractable_.clone();
        SecretKey.putAttributesInTable(secretKey);
        return secretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)object;
            bl = this == secretKey || super.equals(secretKey) && this.sensitive_.equals(secretKey.sensitive_) && this.encrypt_.equals(secretKey.encrypt_) && this.decrypt_.equals(secretKey.decrypt_) && this.sign_.equals(secretKey.sign_) && this.verify_.equals(secretKey.verify_) && this.wrap_.equals(secretKey.wrap_) && this.unwrap_.equals(secretKey.unwrap_) && this.extractable_.equals(secretKey.extractable_) && this.alwaysSensitive_.equals(secretKey.alwaysSensitive_) && this.neverExtractable_.equals(secretKey.neverExtractable_);
        }
        return bl;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive_;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt_;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt_;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        Object.getAttributeValue(session, l, keyTypeAttribute);
        Long l2 = keyTypeAttribute.getLongValue();
        Object object = keyTypeAttribute.isPresent() && l2 != null ? (l2.equals(Key.KeyType.DES) ? DESSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.DES2) ? DES2SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.DES3) ? DES3SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.AES) ? AESSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.RC2) ? RC2SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.RC4) ? RC4SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.RC5) ? RC5SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.IDEA) ? IDEASecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.GENERIC_SECRET) ? GenericSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.CAST) ? CASTSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.CAST3) ? CAST3SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.CAST5) ? CAST5SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.CAST128) ? CAST128SecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.SKIPJACK) ? SkipJackSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.BATON) ? BatonSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.JUNIPER) ? JuniperSecretKey.getInstance(session, l) : (l2.equals(Key.KeyType.CDMF) ? CDMFSecretKey.getInstance(session, l) : ((l2 & Key.KeyType.VENDOR_DEFINED) != 0L ? SecretKey.getUnknownSecretKey(session, l) : SecretKey.getUnknownSecretKey(session, l))))))))))))))))))) : SecretKey.getUnknownSecretKey(session, l);
        return object;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable_;
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive_;
    }

    public BooleanAttribute getSign() {
        return this.sign_;
    }

    protected static Object getUnknownSecretKey(Session session, long l) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (Key.vendorKeyBuilder_ != null) {
            try {
                object = Key.vendorKeyBuilder_.build(session, l);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new SecretKey(session, l);
            }
        } else {
            object = new SecretKey(session, l);
        }
        return object;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap_;
    }

    public BooleanAttribute getVerify() {
        return this.verify_;
    }

    public BooleanAttribute getWrap() {
        return this.wrap_;
    }

    protected static void putAttributesInTable(SecretKey secretKey) {
        if (secretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        secretKey.attributeTable_.put(Attribute.SENSITIVE, secretKey.sensitive_);
        secretKey.attributeTable_.put(Attribute.ENCRYPT, secretKey.encrypt_);
        secretKey.attributeTable_.put(Attribute.DECRYPT, secretKey.decrypt_);
        secretKey.attributeTable_.put(Attribute.SIGN, secretKey.sign_);
        secretKey.attributeTable_.put(Attribute.VERIFY, secretKey.verify_);
        secretKey.attributeTable_.put(Attribute.WRAP, secretKey.wrap_);
        secretKey.attributeTable_.put(Attribute.UNWRAP, secretKey.unwrap_);
        secretKey.attributeTable_.put(Attribute.EXTRACTABLE, secretKey.extractable_);
        secretKey.attributeTable_.put(Attribute.ALWAYS_SENSITIVE, secretKey.alwaysSensitive_);
        secretKey.attributeTable_.put(Attribute.NEVER_EXTRACTABLE, secretKey.neverExtractable_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.sensitive_);
        Object.getAttributeValue(session, this.objectHandle_, this.encrypt_);
        Object.getAttributeValue(session, this.objectHandle_, this.decrypt_);
        Object.getAttributeValue(session, this.objectHandle_, this.sign_);
        Object.getAttributeValue(session, this.objectHandle_, this.verify_);
        Object.getAttributeValue(session, this.objectHandle_, this.wrap_);
        Object.getAttributeValue(session, this.objectHandle_, this.unwrap_);
        Object.getAttributeValue(session, this.objectHandle_, this.extractable_);
        Object.getAttributeValue(session, this.objectHandle_, this.alwaysSensitive_);
        Object.getAttributeValue(session, this.objectHandle_, this.neverExtractable_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sensitive: ");
        stringBuffer.append(this.sensitive_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Encrypt: ");
        stringBuffer.append(this.encrypt_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Decrypt: ");
        stringBuffer.append(this.decrypt_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sign: ");
        stringBuffer.append(this.sign_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Verify: ");
        stringBuffer.append(this.verify_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Wrap: ");
        stringBuffer.append(this.wrap_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Unwrap: ");
        stringBuffer.append(this.unwrap_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Extractable: ");
        stringBuffer.append(this.extractable_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Always Sensitive: ");
        stringBuffer.append(this.alwaysSensitive_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Never Extractable: ");
        stringBuffer.append(this.neverExtractable_.toString());
        return stringBuffer.toString();
    }
}

